<?php $__env->startSection('title'); ?>
    <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><?php echo e($title); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">All <?php echo e($title); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-12">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">All <?php echo e($title); ?></h3>
                        </div>
                        <div class="card-body overflow-x">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">ID</th>
                                        <th>Title</th>
                                        <th width="8%">Location</th>
                                        <th width="8%">Country</th>
                                        <th width="8%">Category</th>
                                        <th width="8%">Sub Category</th>
                                        <th width="8%">Specific Task</th>
                                        <th width="8%">Reqired Proof</th>
                                        <th width="8%">Worker</th>
                                        <th width="8%">Worker Cost</th>
                                        <th width="8%">Screenshot</th>
                                        <th width="8%">Dueration</th>
                                        <th width="8%">Budget</th>
                                        <th width="8%">Pending</th>
                                        <th width="8%">Complete</th>
                                        <th width="8%">Reject</th>
                                        <th>Posted By</th>
                                        <th width="8%">Reason/Remark</th>
                                        <th width="8%">Status</th>
                                        <th width="8%">Date Time</th>
                                        <th width="8%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($data->code); ?><br><?php if($data->pause == 1): ?><span class="badge bg-danger">Paused</span><?php endif; ?></td>
                                            <td><?php echo e($data->title); ?></td>
                                            <td><?php echo e(continent($data->continent_id)); ?></td> <!--<td><?php echo e(location_zone($data->location_zone_id)); ?></td>-->
                                            <td><?php echo e(country($data->location_zone_country)); ?></td>
                                            <td><?php echo e(category($data->category_id)); ?></td>
                                            <td><?php echo e(sub_category($data->sub_category)); ?></td>
                                            <td><?php echo e(specific_task($data->id)); ?></td>
                                            <td><?php echo e($data->required_proof); ?></td>
                                            <td><?php echo e($data->worker_need); ?></td>
                                            <td><?php echo e($data->each_worker_earn); ?>$</td>
                                            <td><?php echo e($data->required_screenshots); ?></td>
                                            <td><?php echo e($data->estimited_day); ?> Days</td>
                                            <td><?php echo e($data->budget); ?>$</td>
                                            <td>
                                                <?php if($data->worker_confirmed < $data->worker_need ): ?>
                                                    <?php echo e(pending_work_for_job($data->id)); ?>

                                                <?php else: ?>
                                                    0
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($data->worker_confirmed > $data->worker_need ): ?>
                                                    <?php echo e($data->worker_need); ?>

                                                <?php else: ?>
                                                    <?php echo e($data->worker_confirmed); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(reject_work_for_job($data->id)); ?></td>
                                            <td><?php echo e(user_name($data->user_id)); ?> <small>(<?php echo e(user_code($data->user_id)); ?>)</small></td>
                                            <td><?php echo e($data->reason); ?></td>
                                            <td>
                                                <?php if($data->worker_confirmed >= $data->worker_need ): ?>
                                                    <span class="badge bg-success">Complete</span>
                                                <?php else: ?>
                                                    <?php if($data->status == 1): ?>
                                                        <span class="badge bg-success">Approved</span>
                                                    <?php elseif($data->status == 2): ?>
                                                        <span class="badge bg-danger">Reject</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger">Pending</span>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo e(\Carbon\Carbon::parse($data->created_at)->format('j M Y g:i A')); ?>

                                            </td>
                                            <td>
                                                <?php if($data->status == 0 || $data->status == 1): ?>
                                                    <a href="<?php echo e(route('admin.job-edit', $data->id)); ?>" class="btn btn-sm btn-info">Edit</a>
                                                <?php endif; ?>

                                                <?php if($data->status == 0): ?>
                                                    <a href="<?php echo e(route('admin.job-approve', $data->id)); ?>" onclick="return confirm(' You want to approved?');" class="btn btn-sm btn-success">Approve</a>
                                                    <a href="javascript:;" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#reject_job<?php echo e($data->id); ?>">
                                                        Reject
                                                    </a>
                                                <?php endif; ?>
                                                <a href="<?php echo e(route('admin.job-delete', $data->id)); ?>" onclick="return confirm(' You want to delete?');" class="btn btn-sm btn-danger">Delete</a>
                                            </td>
                                        </tr>

                                        <div class="modal fade" id="reject_job<?php echo e($data->id); ?>" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <form action="<?php echo e(route('admin.reject-job', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">Reject This Job</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>

                                                        <div class="form-group col-lg-12 col-md-12 col-12">
                                                            <label for="reason">Reason</label>
                                                            <textarea class="form-control" name="reason" id="reason" cols="30" rows="3"><?php echo e($data->reason); ?></textarea>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                            <button type="submit" class="btn btn-primary">Submit</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>

    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
                "pageLength": 3000, // Set the number of items per page
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });

        function depositApproved(id) {
            if (confirm("Are you sure?")) {
                document.getElementById('deposit-approved-'+id).submit();
            }
            return false;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealruom/microjob.dealingwork.com/resources/views/backend/pages/job-manage/index.blade.php ENDPATH**/ ?>